#include <bits/stdc++.h>
#define ll long long
#define endl '\n'
#define pii pair<ll,ll>

using namespace std;

struct P
{
    ll X, Y;
    void in() {cin >> X >> Y;}
    P operator - (P A) {return{X - A.X, Y - A.Y};}
    void operator -= (P A) {X -= A.X; Y -= A.Y;}
    ll operator * (P A) {return (X*A.Y - Y*A.X);}
    bool operator < (P A) {return make_pair(X, Y) < make_pair(A.X, A.Y);}
};

vector <P> get_convex(vector <P> poly, ll N)
{
    vector <P> hull;
    for(int j = 0; j < 2; j++)
    {
        ll S = hull.size();
        for(int i = 0; i < N; i++)
        {
            P C = poly[i];
            while((ll) hull.size() >= S + 2)
            {
                P A = hull.end()[-2];
                P B = hull.end()[-1];
                if((B - A) * (C - A) <= 0) break;
                hull.pop_back();
            }
            hull.push_back(C);
        }
        reverse(poly.begin(), poly.end());
        hull.pop_back();
    }
    return hull;
}

ll find_area(vector <P> points)
{
    ll area = 0;
    ll N = (ll) points.size();
    for(int i = 0; i < N; i++) area += points[i]*points[(i + 1)%N];
    return abs(area)/2;
}

ll cross(P A, P B, P C) {
    return (B.X - A.X) * (C.Y - A.Y) - (B.Y - A.Y) * (C.X - A.X);
}

bool u_trouglu(P A, P B, P C, P D)
{
    ll c1 = cross(A, B, D);
    ll c2 = cross(B, C, D);
    ll c3 = cross(C, A, D);
    return (c1 >= 0 && c2 >= 0 && c3 >= 0) || (c1 <= 0 && c2 <= 0 && c3 <= 0);
}

double angle(P A, P B) {A -= B; return atan2(A.Y, A.X);}

void find_idx(vector <P> poly, ll N, P B, vector <P> where[])
{
    ll L = 0, R = N;
    ll idx = -1;
    double ang = angle(B, poly[0]);
    while(R - L >= 2)
    {
        ll mid = (L + R)/2;
        double ang1 = angle(poly[(mid - 1 + N)%N], poly[0]);
        double ang2 = angle(poly[mid%N], poly[0]);
        double ang3 = angle(poly[(mid + 1)%N], poly[0]);
        if(ang >= min({ang1, ang2, ang3}) && ang <= max({ang1, ang2, ang3})) {idx = mid; break;}
        if(ang > max({ang1, ang2, ang3})) R = mid;
        else L = mid;
    }
    if(idx == -1) return;
    if(u_trouglu(poly[(idx - 1 + N)%N], poly[idx%N], poly[(idx + 1)%N], B)) where[(idx - 1 + N)%N].push_back(B);
    if(u_trouglu(poly[idx%N], poly[(idx + 1)%N], poly[(idx + 2)%N], B)) where[idx%N].push_back(B);
    if(u_trouglu(poly[(idx + 1)%N], poly[(idx + 2)%N], poly[(idx + 3)%N], B)) where[(idx + 1)%N].push_back(B);
}

int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    ll N;
    cin >> N;
    vector <P> poly(N);
    vector <P> where[N];
    map <pii, bool> in_convex;
    map <pii, int> idx;
    for(int i = 0; i < N; i++) poly[i].in();
    sort(poly.begin(), poly.end());
    vector <P> hull = get_convex(poly, N);
    ll beg_area = find_area(hull);
    ll S = (ll) hull.size();
    ll res = beg_area;
    for(int i = 0; i < S; i++) {in_convex[{hull[i].X, hull[i].Y}] = true; idx[{hull[i].X, hull[i].Y}] = i;}
    for(int i = 0; i < N; i++)
    {
        if(in_convex[{poly[i].X, poly[i].Y}]) continue;
        find_idx(hull, S, poly[i], where);
    }
    for(int i = 0; i < S; i++)
    {
        ll area_now;
        P uno = hull[i];
        P dos = hull[(i + 1)%S];
        P tres = hull[(i + 2)%S];
        vector <P> trougao; trougao.push_back(uno); trougao.push_back(dos); trougao.push_back(tres);
        if(((ll) where[idx[{uno.X, uno.Y}]].size()) == 0) area_now = find_area(trougao);
        else
        {
            vector <P> points;
            points.push_back(uno);
            for(auto p : where[idx[{uno.X, uno.Y}]]) points.push_back(p);
            points.push_back(tres);
            vector <P> this_hull = get_convex(points, (ll) points.size());
            area_now = find_area(trougao) - find_area(this_hull);
        }
        res = min(res, beg_area - area_now);
    }
    cout << res << endl;
    return 0;
}
/**
28
20 10
40 16
34 36
36 32
26 30
38 26
28 20
20 24
14 16
24 18
32 18
28 14
34 28
30 28
36 20
16 40
10 10
44 38
32 6
22 32
14 34
18 22
26 36
16 26
42 24
38 12
6 30
4 22
**/